<?php
/*
Plugin Name: Bitcoinpostage for WooCommerce
Description: Bitcoinpostage for WooCommerce. Supports PHP 8.x and HPOS
Version: 1.04
Author: Bitcoinpostage.info
Author URI: https://bitcoinpostage.info/
Tested up to: 6.7.1
*/

function register_bitcoin_postage_settings()
{
    register_setting('bitcoin-postage-settings', 'btc_postage_api_key');
    register_setting('bitcoin-postage-settings', 'btc_postage_secret_key');
    register_setting('bitcoin-postage-settings', 'btc_postage_sender_name');
    register_setting('bitcoin-postage-settings', 'btc_postage_sender_address');
    register_setting('bitcoin-postage-settings', 'btc_postage_sender_apt');
    register_setting('bitcoin-postage-settings', 'btc_postage_sender_city');
    register_setting('bitcoin-postage-settings', 'btc_postage_sender_state');
    register_setting('bitcoin-postage-settings', 'btc_postage_sender_zipcode');
    register_setting('bitcoin-postage-settings', 'btc_postage_sender_country');
    register_setting('bitcoin-postage-settings', 'btc_postage_sender_phone');
}

add_action('admin_init', 'register_bitcoin_postage_settings');

function register_bitcoin_postage_submenu()
{
    add_submenu_page('woocommerce', 'BitcoinPostage Settings', 'BitcoinPostage', 'manage_woocommerce', 'bitcoin-postage', 'bitcoin_postage_page_callback');
}


function register_bitcoin_postage_print_label_page()
{
    add_submenu_page(null, 'BitcoinPostage Settings', 'BitcoinPostage', 'manage_woocommerce', 'bitcoin-postage-print-label', 'bitcoin_postage_print_label_page_callback');
}


function bitcoin_postage_page_callback()
{
    echo '<h2>BitcoinPostage Settings</h2>';

    echo '
    <div class="bitcoin-postage">
    <form method="post" action="options.php">';

    settings_fields('bitcoin-postage-settings');
    do_settings_sections('bitcoin-postage-settings');


    echo '<table class="form-table">
    <tbody>
        <tr valign="top">
		    <th scope="row" class="titledesc">
				<label for="btc_postage_api_key">API Key</label>
			</th>
			<td class="forminp forminp-text">
				<input name="btc_postage_api_key" id="btc_postage_api_key" type="text" style="" value="' . get_option("btc_postage_api_key") . '" class="" placeholder=""> 	
			</td>
		</tr>
		<tr valign="top">
			<th scope="row" class="titledesc">
				<label for="btc_postage_secret_key">Secret</label>
			</th>
		    <td class="forminp forminp-text">
				<input name="btc_postage_secret_key" id="btc_postage_secret_key" type="text" style="" value="' . get_option("btc_postage_secret_key") . '" class="" placeholder=""> 	
			</td>
		</tr>'.bitcoin_postage_balance_tr().'
		<tr><td colspan="2" style="padding: 0;"><h4>Default Sender Address</h4></td></tr>
		<tr valign="top">		
			<th scope="row" class="titledesc">
				<label for="btc_postage_sender_name">Name</label>
			</th>
		    <td class="forminp forminp-text">
				 <input name="btc_postage_sender_name" id="btc_postage_sender_name" type="text" style="" value="' . get_option("btc_postage_sender_name") . '" class="">	
			</td>
		</tr>
		<tr valign="top">		
			<th scope="row" class="titledesc">
				<label for="btc_postage_sender_address">Street Address</label>
			</th>
		    <td class="forminp forminp-text">
				 <input name="btc_postage_sender_address" id="btc_postage_sender_address" type="text" style="" value="' . get_option("btc_postage_sender_address") . '" class="">	
			</td>
		</tr>
		<tr valign="top">		
			<th scope="row" class="titledesc">
				<label for="btc_postage_sender_apt">Apt / Suite</label>
			</th>
		    <td class="forminp forminp-text">
				 <input name="btc_postage_sender_apt" id="btc_postage_sender_apt" type="text" style="" value="' . get_option("btc_postage_sender_apt") . '" class="">	
			</td>
		</tr>
		<tr valign="top">		
			<th scope="row" class="titledesc">
				<label for="btc_postage_sender_city">City</label>
			</th>
		    <td class="forminp forminp-text">
				 <input name="btc_postage_sender_city" id="btc_postage_sender_city" type="text" style="" value="' . get_option("btc_postage_sender_city") . '" class="">	
			</td>
		</tr>
		<tr valign="top">		
			<th scope="row" class="titledesc">
				<label for="btc_postage_sender_state">State</label>
			</th>
		    <td class="forminp forminp-text">
				 <input name="btc_postage_sender_state" id="btc_postage_sender_state" type="text" style="" value="' . get_option("btc_postage_sender_state") . '" class="">	
			</td>
		</tr>
		<tr valign="top">		
			<th scope="row" class="titledesc">
				<label for="btc_postage_sender_zipcode">Zip Code</label>
			</th>
		    <td class="forminp forminp-text">
				 <input name="btc_postage_sender_zipcode" id="btc_postage_sender_zipcode" type="text" style="" value="' . get_option("btc_postage_sender_zipcode") . '" class="">		
			</td>
		</tr>
		<tr valign="top">		
			<th scope="row" class="titledesc">
				<label for="btc_postage_sender_country">Country Code</label>
			</th>
		    <td class="forminp forminp-text">
			    <input name="btc_postage_sender_country" id="btc_postage_sender_country" type="text" style="" value="' . get_option("btc_postage_sender_country") . '" class="">		
			</td>
		</tr>		
		<tr valign="top">		
			<th scope="row" class="titledesc">
				<label for="btc_postage_sender_phone">Phone Number</label>
			</th>
		    <td class="forminp forminp-text">
				 <input name="btc_postage_sender_phone" id="btc_postage_sender_phone" type="text" style="" value="' . get_option("btc_postage_sender_phone") . '" class="">		
            </td>
		</tr>	
	   </tbody>
	</table>' . get_submit_button() . '	
    </form>
	</div>';

}

function bitcoin_postage_print_label_page_callback()
{
    global $country_option_list;
    global $wpdb;

    if(!isset($_GET["view"])) {

        echo '<h2>BitcoinPostage Print Label</h2>';

		$order_info = new WC_Order(intval($_GET["order"]));

        $address2 = get_post_meta(intval($_GET["order"]), "_shipping_address_2", true);
		if($address2 == "") {
			$address2 = $order_info->shipping_address_2;
		}
        if ($address2 != "") {
            $address2 = ' ' . $address2;
        }

		$shipping_first_name = get_post_meta(intval($_GET["order"]), "_shipping_first_name", true);
		if($shipping_first_name == "") $shipping_first_name = $order_info->shipping_first_name;

		$shipping_last_name = get_post_meta(intval($_GET["order"]), "_shipping_last_name", true);
		if($shipping_last_name == "") $shipping_last_name = $order_info->shipping_last_name;

		$shipping_address_1 = get_post_meta(intval($_GET["order"]), "_shipping_address_1", true);
		if($shipping_address_1 == "") $shipping_address_1 = $order_info->shipping_address_1;

		$shipping_address_2 = get_post_meta(intval($_GET["order"]), "_shipping_address_2", true);
		if($shipping_address_2 == "") $shipping_address_2 = $order_info->shipping_address_2;

		$shipping_city = get_post_meta(intval($_GET["order"]), "_shipping_city", true);
		if($shipping_city == "") $shipping_city = $order_info->shipping_city;

		$shipping_state = get_post_meta(intval($_GET["order"]), "_shipping_state", true);
		if($shipping_state == "") $shipping_state = $order_info->shipping_state;

		$shipping_postcode = get_post_meta(intval($_GET["order"]), "_shipping_postcode", true);
		if($shipping_postcode == "") $shipping_postcode = $order_info->shipping_postcode;

		$shipping_phone = get_post_meta(intval($_GET["order"]), "_shipping_phone", true);
		if($shipping_phone == "") $shipping_phone = $order_info->shipping_phone;

		$shipping_country = get_post_meta(intval($_GET["order"]), "_shipping_country", true);
		if($shipping_country == "") $shipping_country = $order_info->shipping_country;



        echo '
<div class="bitcoin-postage">
<div class="create-label-block">
<form id="btc-postage-print-label-form">
    <div class="line-form">
        <label for="carrier">Carrier</label>
        <select name="carrier" id="carrier" onchange="changeCarrier(this)">
            <option value="usps">USPS</option>    
            <option value="canadapost">CanadaPost</option>    
        </select>       
    </div>
    <div class="line-form" id="carrier_usps">
        <label for="packagetype_usps">Package Type</label>
        <select class="form-field" name="packagetype_usps" id="packagetype_usps" onchange="changePackage(this);">
            <option value="" disabled selected>-- Click to Select --</option>
            <option value="USPScustom">Custom Box/Package (Most Common)</option>  
            <option value="Flat">Flat</option>
            <option value="Parcel">Parcel</option>
            <option value="LargeParcel">LargeParcel</option>
            <option value="IrregularParcel">Irregular Size (Rolls, Tubes)</option>
            <option value="Softpack">Softpack</option>
            <option value="Letter">Letter</option>
            <option value="FlatRateEnvelope">Flat Rate Envelope - Letter</option>
            <option value="FlatRateLegalEnvelope">Flat Rate Envelope - Legal</option>
            <option value="FlatRatePaddedEnvelope">Flat Rate Envelope - Padded</option>
            <option value="SmallFlatRateEnvelope">Flat Rate Envelope - Small</option>
            <option value="FlatRateWindowEnvelope">Flat Rate Envelope - Window</option>
            <option value="FlatRateGiftCardEnvelope">Flat Rate Envelope - Gift Card</option>
            <option value="FlatRateCardboardEnvelope">Flat Rate Envelope - Cardboard</option>
            <option value="SmallFlatRateBox">Flat Rate Box - Small</option>
            <option value="MediumFlatRateBox">Flat Rate Box - Medium</option>
            <option value="LargeFlatRateBox">Flat Rate Box - Large</option>
            <option value="LargeFlatRateBoardGameBox">Flat Rate Box - Large Board Game</option>
            <option value="RegionalRateBoxA">Regional Rate Box A</option>
            <option value="RegionalRateBoxB">Regional Rate Box B</option>
        </select>
        <div id="carrier_usps_custommsg" class="bottom-label-desc"></div>
    </div>
    <div class="line-form" id="carrier_fedex" style="display:none;">
        <label for="packagetype_fedex">Package Type</label>
        <select class="form-field" name="packagetype_fedex" id="packagetype_fedex" onchange="changePackage(this);">
            <option value="" disabled selected>-- Click to Select --</option>
            <option value="FedExcustom">Custom Box/Package (Most Common)</option>
            <option value="FedExEnvelope">Flat Rate Envelope</option>
            <option value="FedExPak">Flat Rate Box - FedExPak</option>
            <option value="FedExSmallBox">Flat Rate Box - FedExSmallBox</option>
            <option value="FedExMediumBox">Flat Rate Box - FedExMediumBox</option>
            <option value="FedExLargeBox">Flat Rate Box - FedExLargeBox</option>
            <option value="FedExExtraLargeBox">Flat Rate Box - FedExExtraLargeBox</option>
            <option value="FedExTube">Flat Rate Tube - FedExTube</option>
        </select>
        <div id="carrier_fedex_custommsg" class="bottom-label-desc">Phone number is required for FedEx shipments.</div>
    </div>
    <div class="line-form" id="carrier_dhl" style="display:none;">
        <label for="packagetype_dhl">Package Type</label>
        <select class="form-field" name="packagetype_dhl" id="packagetype_dhl" onchange="changePackage(this);">
            <option value="" disabled selected>-- Click to Select --</option>
            <option value="custom">Custom Box/Package (Most Common)</option>
            <option value="JumboDocument">Flat Rate Envelope - JumboDocument</option>
            <option value="Document">Flat Rate Envelope - Document</option>
            <option value="DHLFlyer">Flat Rate Envelope - DHLFlyer</option>
            <option value="ExpressDocument">Flat Rate Envelope - ExpressDocument</option>
            <option value="DHLExpressEnvelope">Flat Rate Envelope - DHLExpressEnvelope</option>
            <option value="JumboJuniorDocument">Flat Rate Envelope - JumboJuniorDocument</option>
            <option value="JumboJuniorParcel">Flat Rate Box - JumboJuniorParcel</option>
            <option value="JumboParcel">Flat Rate Box - JumboParcel</option>
            <option value="JumboBox">Flat Rate Box - JumboBox</option>
            <option value="JuniorJumboBox">Flat Rate Box - JuniorJumboBox</option>
        </select>
        <div id="carrier_dhl_custommsg" class="bottom-label-desc">International only. Each shipment generates two documents.</div>
    </div>    
    <div class="line-form" id="carrier_canadapost" style="display:none;">
        <label for="packagetype_canadapost">Package Type</label>
        <select class="form-field" name="packagetype_canadapost" id="packagetype_canadapost" onchange="changePackage(this);">
            <option value="" disabled selected>-- Click to Select --</option>
            <option value="canadapost_custom">Custom Box/Package</option>
        </select>
        <div id="carrier_canadapost_custommsg" class="bottom-label-desc"></div>
    </div>
    <div class="line-form" id="carrier_parcelforce" style="display:none;">
        <div id="carrier_parcelforce_custommsg" class="bottom-label-desc">Parcels must not exceed 5 meters in length and girth combined, 2.5 meters in length, or 30kg.</div>
    </div>
    <div class="line-form" id="carrier_fastway" style="display:none;">
        <label for="packagetype_fastway">Package Type</label>
        <select class="form-field" name="packagetype_fastway" id="packagetype_fastway" onchange="changePackage(this);">
            <option value="" disabled selected>-- Click to Select --</option>
            <option value="custom">Custom Box/Package</option>
            <option value="Fastway_Australia_Satchel_A2">Satchel A2</option>
            <option value="Fastway_Australia_Satchel_A3">Satchel A3</option>
            <option value="Fastway_Australia_Satchel_A4">Satchel A4</option>
            <option value="Fastway_Australia_Satchel_A5">Satchel A5</option>
        </select>
        <div id="carrier_fastway_custommsg" class="bottom-label-desc">Note: Fastway accepts parcels within the following limits.<br>
        Actual weight up to 18kg<br>
        Cubic weight up to 9kg<br>
        Maximum of 1 metre in length
        </div>
    </div>
    <div class="line-form" id="carrier_sendle" style="display:none;">
        <div id="carrier_sendle_custommsg" class="bottom-label-desc"></div>
    </div>

    <div class="line-form" id="carrier_couriersplease" style="display:none;">
        <label for="packagetype_couriersplease">Package Type</label>
        <select class="form-field" name="packagetype_couriersplease" id="packagetype_couriersplease" onchange="changePackage(this);">
            <option value="" disabled selected>-- Click to Select --</option>
            <option value="custom">Custom Box/Package</option>
            <option value="couriersplease_500g_satchel">500g Satchel</option>
            <option value="couriersplease_1kg_satchel">1kg Satchel</option>
            <option value="couriersplease_3kg_satchel">3kg Satchel</option>
            <option value="couriersplease_5kg_satchel">5kg Satchel</option>
        </select>
        <div id="carrier_couriersplease_custommsg" class="bottom-label-desc"></div>
    </div>
    <div class="line-form" id="carrier_deutschepost" style="display:none;">
        <div id="carrier_deutschepost_custommsg" class="bottom-label-desc"></div>
    </div>
    <div class="line-form" id="carrier_hongkongpost" style="display:none;">
        <div id="carrier_hongkongpost_custommsg" class="bottom-label-desc"></div>
    </div>
    <div style="display: none">
        <input type="hidden" id="carrier_none" value="">
        <select name="packagetype_none" id="packagetype_none" style="visibility: hidden;">
            <option value=""></option>
        </select>
        <input type="hidden" name="xverify" value="">
        <input type="hidden" name="xreqs" value="">
        <input type="hidden" name="xerrors" value="">
        <input type="hidden" name="xerrors2" value="">
        <input type="hidden" name="xtotalweight" value="">
        <input type="hidden" name="xtotalvalue" value="">
        <input type="hidden" name="order_id" value="' . $_GET["order"] . '">
    </div>
    <div class="line-form"><hr></div>
    <div class="line-form">
        <div class="col-big-6 col-left" id="dimension_wrapper">
            <div class="title-col">Dimensions (in inches)</div>
            <div class="col-4 col-left" id="div_length">
                <label for="input_length">Length</label>
                <input type="text" name="input_length" id="input_length">
            </div>
            <div class="col-4 col-middle" id="div_width">
                <label for="input_width">Width</label>
                <input type="text" name="input_width" id="input_width">
            </div>
            <div class="col-4 col-right" id="div_height">
                <label for="input_height">Height</label>
                <input type="text" name="input_height" id="input_height">
            </div>
        </div>
        <div class="col-big-6 col-right">
            <div class="title-col">Package Weight</div>
            <div class="col-6 col-left">
                <label for="input_weight_lbs">Lbs</label>
                <input type="text" name="input_weight_lbs" id="input_weight_lbs">
            </div>
            <div class="col-6 col-right">
                <label for="input_weight_oz">Oz</label>
                <input type="text" id="input_weight_oz" name="input_weight_oz">
            </div>
        </div>
        <div id="weight_custommsg" class="bottom-label-desc">Note: We recommend over-estimating the weight of your package so that it doesn\'t get returned back to you for underpayment.</div>
    </div>
    <div class="line-form">
        <hr>
    </div>
    <div class="line-form">
        <div class="col-big-6 col-left">
            <div class="title-col">From</div>
            <div class="line-form">
                <label for="from_name">Name</label>
                <input type="text" name="from_name" id="from_name" value="'.get_option("btc_postage_sender_name").'">
            </div>
            <div class="line-form">
                <label for="from_street">Street Address</label>
                <input type="text" name="from_street" id="from_street" value="'.get_option("btc_postage_sender_address").'">
            </div>
            <div class="line-form">
                <label for="from_apt">Apt / Suite</label>
                <input type="text" name="from_apt" id="from_apt" value="'.get_option("btc_postage_sender_apt").'">
            </div>
            <div class="line-form">
                <label for="from_city">City</label>
                <input type="text" name="from_city" id="from_city" value="'.get_option("btc_postage_sender_city").'">
            </div>
            <div class="line-form">
               <div class="col-6 col-left">
                   <label for="from_state">State</label>
                   <input type="text" id="from_state" name="from_state" value="'.get_option("btc_postage_sender_state").'">
               </div>
               <div class="col-6 col-right">
                   <label for="from_zip">Zip Code</label>
                   <input type="text" name="from_zip" id="from_zip" value="'.get_option("btc_postage_sender_zipcode").'">
               </div>                
            </div>
            <div class="line-form">
                <label for="from_country">Country</label>
                <select name="from_country" id="from_country">
                    <option value="" disabled selected>-- Click to Select --</option>
                ' . $country_option_list . '                
                </select>
            </div>
            <div class="line-form">
                <label for="from_phone">Phone Number<br><span class="small-desc">(Only required for Express shipping)</span></label>
                <input type="text" name="from_phone" id="from_phone" value="'.get_option("btc_postage_sender_phone").'">
                <div style="margin-top: 10px;"> <input type="checkbox" id="btc-postage-save-sender" name="btc_postage_save_sender"> <label for="btc-postage-save-sender" class="btc-postage-save-sender-label">Save Sender Address</label></div>
            </div>
        </div>
        <div class="col-big-6 col-right">
            <div class="title-col">To</div>
            <div class="line-form">
                <label for="to_name">Name</label>
                <input type="text" name="to_name" id="to_name" value="' . $shipping_first_name . ' ' . $shipping_last_name . '">
            </div>
            <div class="line-form">
                <label for="to_street">Street Address</label>
                <input type="text" name="to_street" id="to_street" value="' . $shipping_address_1 . '">
            </div>
            <div class="line-form">
                <label for="street2">Apt / Suite</label>
                <input type="text" name="to_street2" id="street2" value="' . $shipping_address_2 . '">
            </div>
            <div class="line-form">
                <label for="to_city">City</label>
                <input type="text" name="to_city" id="to_city" value="' . $shipping_city . '">
            </div>
            <div class="line-form">
                <div class="col-6 col-left">
                    <label for="to_state">State</label>
                    <input type="text" name="to_state" id="to_state" value="' . $shipping_state . '">
                </div>
                <div class="col-6 col-right">
                    <label for="to_zip">Zip Code</label>
                    <input type="text" name="to_zip" id="to_zip" value="' . $shipping_postcode . '">
                </div>                            
            </div>
            <div class="line-form">
                <label for="to_country">Country</label>
                <select name="to_country" id="to_country">
                    <option value="" disabled>-- Click to Select --</option>
                        ' . $country_option_list . '                
                </select>
            </div>
            <div class="line-form">
                <label for="to_phone">Phone Number<br><span class="small-desc">(Only required for Express shipping)</span></label>
                <input type="text" name="to_phone" id="to_phone" value="' . $shipping_phone . '">
            </div>   
        </div>
        <div class="line-form loading-line">
        <div id="floatBarsG">
	        <div id="floatBarsG_1" class="floatBarsG"></div>
	        <div id="floatBarsG_2" class="floatBarsG"></div>
            <div id="floatBarsG_3" class="floatBarsG"></div>
            <div id="floatBarsG_4" class="floatBarsG"></div>
            <div id="floatBarsG_5" class="floatBarsG"></div>
            <div id="floatBarsG_6" class="floatBarsG"></div>
            <div id="floatBarsG_7" class="floatBarsG"></div>
            <div id="floatBarsG_8" class="floatBarsG"></div>
        </div>
        </div>
        <div class="line-form rates-block">
    
        </div>
        <div class="line-form submit-line">
            <input type="submit" name="submit" id="submit" class="button button-primary button-large" value="Get Rates">
        </div>
     </div>
        
</form>
</div>   
</div>' . btc_postage_get_ajax_form();


    }
    else {

        echo '<h2>BitcoinPostage Print Label for Order #'.intval($_GET["order"]).'</h2>';

        $label_row  = $wpdb->get_row( "SELECT * FROM ".$wpdb->prefix."btc_post_labels WHERE order_id = '".intval($_GET["order"])."' ORDER by id LIMIT 1");

        $label_src = '';

        if($label_row!=NULL) {
            $label_src = $label_row->label;
        }

        echo '
<div class="bitcoin-postage">
<div class="create-label-block">
<form id="btc-postage-print-label-form">
<div class="line-form">
<div class="back-orders"><a href="'.admin_url("edit.php?post_type=shop_order").'">Back to Orders</a></div>
</div>
    <div class="line-form">
        <label for="label">Label</label>
        <div class="label-block"><img src="'.$label_src.'" class="bitcoin-postage-label-img"></div>
    </div>
    <div class="line-form submit-line">
            <input type="button" class="button button-primary button-large btc-label-print-button" value="Print Label" onclick="printLabel(); return false;">
     </div>
</form>
</div>
</div>';
    }

}

add_action('admin_menu', 'register_bitcoin_postage_submenu', 99);
add_action('admin_menu', 'register_bitcoin_postage_print_label_page', 99);


function bitcoin_postage_add_stylesheet_to_admin()
{
    wp_enqueue_style('bitcoin_postage-select2', plugins_url('assets/css/select2.min.css', __FILE__));
    wp_enqueue_style('bitcoin_postage-admin-css', plugins_url('assets/css/btc-postage.css', __FILE__));
}

add_action('admin_enqueue_scripts', 'bitcoin_postage_add_stylesheet_to_admin');

function bitcoin_postage_add_script_to_admin()
{
    wp_enqueue_script('bitcoin_postage-select2', plugins_url('assets/js/select2.min.js', __FILE__));
    wp_enqueue_script('bitcoin_postage-admin-script', plugins_url('assets/js/btc-postage.js', __FILE__));
}

add_action('admin_enqueue_scripts', 'bitcoin_postage_add_script_to_admin');


function add_custom_column_to_shop_order($columns)
{
    $new_columns = is_array($columns) ? $columns : array();
    $new_columns['btc_postage'] = __('BitcoinPostage');
    return $new_columns;
}

add_filter('manage_edit-shop_order_columns', 'add_custom_column_to_shop_order');

function add_custom_column_value_to_shop_order($column)
{
    global $post;
    global $wpdb;

    if ($column == 'btc_postage') {
        $id_post = intval($post->ID);
        $order = wc_get_order( $id_post );

        if($order->get_status()=="pending" || $order->get_status()=="processing" || $order->get_status()=="on-hold") {
            $label_row  = $wpdb->get_row( "SELECT * FROM ".$wpdb->prefix."btc_post_labels WHERE order_id = '".intval($id_post)."' ORDER by id LIMIT 1");
            if($label_row==NULL) {
                echo '<a href="'.admin_url("admin.php?page=bitcoin-postage-print-label&order=".$id_post).'"><button type="button" class="button btc-postage-btn-print">Create Label</button></a>';
            } else {
                echo '<a href="'.admin_url("admin.php?page=bitcoin-postage-print-label&order=".$id_post."&view=1").'"><button type="button" class="button btc-postage-btn-print">Print Label</button></a>';
            }
        }
    }
}

add_action('manage_shop_order_posts_custom_column', 'add_custom_column_value_to_shop_order');


add_filter( 'woocommerce_shop_order_list_table_columns', function ( $columns ) {
	$columns['btc_postage'] = 'BitcoinPostage';
	return $columns;
} );

add_action( 'woocommerce_shop_order_list_table_custom_column', function ( $column, $order ) {
	if ( 'btc_postage' !== $column ) {
		return;
	} else {
		$id_post = intval($order->ID);
		global $wpdb;

        if($order->status=="pending" || $order->status=="processing" || $order->status=="on-hold") {
            $label_row  = $wpdb->get_row( "SELECT * FROM ".$wpdb->prefix."btc_post_labels WHERE order_id = '".intval($id_post)."' ORDER by id LIMIT 1");
            if($label_row==NULL) {
                echo '<a href="'.admin_url("admin.php?page=bitcoin-postage-print-label&order=".$id_post).'"><button type="button" class="button btc-postage-btn-print">Create Label</button></a>';
            } else {
                echo '<a href="'.admin_url("admin.php?page=bitcoin-postage-print-label&order=".$id_post."&view=1").'"><button type="button" class="button btc-postage-btn-print">Print Label</button></a>';
            }
        }
	}

}, 10, 2 );

$country_option_list = '<option value="US">United States</option>
<option value="GB">United Kingdom</option>
<option value="CA">Canada</option>
<option value="AF">Afghanistan</option>
<option value="AX">Aland Islands</option>
<option value="AL">Albania</option>
<option value="DZ">Algeria</option>
<option value="AS">American Samoa</option>
<option value="AD">Andorra</option>
<option value="AO">Angola</option>
<option value="AI">Anguilla</option>
<option value="AQ">Antarctica</option>
<option value="AG">Antigua and Barbuda</option>
<option value="AR">Argentina</option>
<option value="AM">Armenia</option>
<option value="AW">Aruba</option>
<option value="AU">Australia</option>
<option value="AT">Austria</option>
<option value="AZ">Azerbaijan</option>
<option value="BS">Bahamas</option>
<option value="BH">Bahrain</option>
<option value="BD">Bangladesh</option>
<option value="BB">Barbados</option>
<option value="BY">Belarus</option>
<option value="BE">Belgium</option>
<option value="BZ">Belize</option>
<option value="BJ">Benin</option>
<option value="BM">Bermuda</option>
<option value="BT">Bhutan</option>
<option value="BO">Bolivia</option>
<option value="BQ">Bonaire</option>
<option value="BA">Bosnia and Herzegovina</option>
<option value="BW">Botswana</option>
<option value="BR">Brazil</option>
<option value="BN">Brunei Darussalam</option>
<option value="BG">Bulgaria</option>
<option value="BF">Burkina Faso</option>
<option value="BI">Burundi</option>
<option value="KH">Cambodia</option>
<option value="CM">Cameroon</option>
<option value="CV">Cape Verde</option>
<option value="KY">Cayman Islands</option>
<option value="CF">Central African Republic</option>
<option value="TD">Chad</option>
<option value="CL">Chile</option>
<option value="CN">China</option>
<option value="CO">Colombia</option>
<option value="HM">Comoros</option>
<option value="CG">Congo</option>
<option value="CD">Congo, the Democratic Republic of the</option>
<option value="CK">Cook Islands</option>
<option value="HR">Croatia</option>
<option value="CU">Cuba</option>
<option value="CW">Curacao</option>
<option value="CY">Cyprus</option>
<option value="CZ">Czech Republic</option>
<option value="CI">Cote d\'Ivoire</option>
<option value="DK">Denmark</option>
<option value="DJ">Djibouti</option>
<option value="DM">Dominica</option>
<option value="DO">Dominican Republic</option>
<option value="EC">Ecuador</option>
<option value="EG">Egypt</option>
<option value="SV">El Salvador</option>
<option value="GQ">Equatorial Guinea</option>
<option value="ER">Eritrea</option>
<option value="EE">Estonia</option>
<option value="ET">Ethiopia</option>
<option value="FK">Falkland Islands (Malvinas)</option>
<option value="FO">Faroe Islands</option>
<option value="FJ">Fiji</option>
<option value="FI">Finland</option>
<option value="FR">France</option>
<option value="GF">French Guiana</option>
<option value="PF">French Polynesia</option>
<option value="GA">Gabon</option>
<option value="GM">Gambia</option>
<option value="GE">Georgia</option>
<option value="DE">Germany</option>
<option value="GH">Ghana</option>
<option value="GI">Gibraltar</option>
<option value="GR">Greece</option>
<option value="GL">Greenland</option>
<option value="GD">Grenada</option>
<option value="GP">Guadeloupe</option>
<option value="GU">Guam</option>
<option value="GT">Guatemala</option>
<option value="GG">Guernsey</option>
<option value="GN">Guinea</option>
<option value="GW">Guinea-Bissau</option>
<option value="GY">Guyana</option>
<option value="HT">Haiti</option>
<option value="VA">Holy See (Vatican City State)</option>
<option value="HN">Honduras</option>
<option value="HK">Hong Kong</option>
<option value="HU">Hungary</option>
<option value="IS">Iceland</option>
<option value="IN">India</option>
<option value="ID">Indonesia</option>
<option value="IR">Iran</option>
<option value="IQ">Iraq</option>
<option value="IE">Ireland</option>
<option value="IM">Isle of Man</option>
<option value="IL">Israel</option>
<option value="IT">Italy</option>
<option value="JM">Jamaica</option>
<option value="JP">Japan</option>
<option value="JE">Jersey</option>
<option value="JO">Jordan</option>
<option value="KZ">Kazakhstan</option>
<option value="KE">Kenya</option>
<option value="KI">Kiribati</option>
<option value="KP">Korea, Democratic People\'s Republic of</option>
<option value="KR">Korea, Republic of</option>
<option value="KW">Kuwait</option>
<option value="KG">Kyrgyzstan</option>
<option value="LA">Lao People\'s Democratic Republic</option>
<option value="LV">Latvia</option>
<option value="LB">Lebanon</option>
<option value="LS">Lesotho</option>
<option value="LR">Liberia</option>
<option value="LY">Libya</option>
<option value="LI">Liechtenstein</option>
<option value="LT">Lithuania</option>
<option value="LU">Luxembourg</option>
<option value="MO">Macao</option>
<option value="MK">Macedonia</option>
<option value="MG">Madagascar</option>
<option value="MW">Malawi</option>
<option value="MY">Malaysia</option>
<option value="MV">Maldives</option>
<option value="ML">Mali</option>
<option value="MT">Malta</option>
<option value="MH">Marshall Islands</option>
<option value="MQ">Martinique</option>
<option value="MR">Mauritania</option>
<option value="MU">Mauritius</option>
<option value="YT">Mayotte</option>
<option value="MX">Mexico</option>
<option value="FM">Micronesia</option>
<option value="MD">Moldova</option>
<option value="MC">Monaco</option>
<option value="MN">Mongolia</option>
<option value="ME">Montenegro</option>
<option value="MS">Montserrat</option>
<option value="MA">Morocco</option>
<option value="MZ">Mozambique</option>
<option value="MM">Myanmar</option>
<option value="NA">Namibia</option>
<option value="NR">Nauru</option>
<option value="NP">Nepal</option>
<option value="NL">Netherlands</option>
<option value="NC">New Caledonia</option>
<option value="NZ">New Zealand</option>
<option value="NI">Nicaragua</option>
<option value="NE">Niger</option>
<option value="NG">Nigeria</option>
<option value="NU">Niue</option>
<option value="NF">Norfolk Island</option>
<option value="MP">Northern Mariana Islands</option>
<option value="NO">Norway</option>
<option value="OM">Oman</option>
<option value="PK">Pakistan</option>
<option value="PW">Palau</option>
<option value="PS">Palestine</option>
<option value="PA">Panama</option>
<option value="PG">Papua New Guinea</option>
<option value="PY">Paraguay</option>
<option value="PE">Peru</option>
<option value="PH">Philippines</option>
<option value="PN">Pitcairn</option>
<option value="PL">Poland</option>
<option value="PT">Portugal</option>
<option value="PR">Puerto Rico</option>
<option value="QA">Qatar</option>
<option value="RO">Romania</option>
<option value="RU">Russian Federation</option>
<option value="RW">Rwanda</option>
<option value="RE">Reunion</option>
<option value="BL">Saint Barthelemy</option>
<option value="SH">Saint Helena</option>
<option value="KN">Saint Kitts and Nevis</option>
<option value="LC">Saint Lucia</option>
<option value="MF">Saint Martin (French part)</option>
<option value="PM">Saint Pierre and Miquelon</option>
<option value="VC">Saint Vincent and the Grenadines</option>
<option value="WS">Samoa</option>
<option value="SM">San Marino</option>
<option value="ST">Sao Tome and Principe</option>
<option value="SA">Saudi Arabia</option>
<option value="SN">Senegal</option>
<option value="RS">Serbia</option>
<option value="SC">Seychelles</option>
<option value="SL">Sierra Leone</option>
<option value="SG">Singapore</option>
<option value="SX">Sint Maarten (Dutch part)</option>
<option value="SK">Slovakia</option>
<option value="SI">Slovenia</option>
<option value="SB">Solomon Islands</option>
<option value="SO">Somalia</option>
<option value="ZA">South Africa</option>
<option value="SS">South Sudan</option>
<option value="ES">Spain</option>
<option value="LK">Sri Lanka</option>
<option value="SD">Sudan</option>
<option value="SR">Suriname</option>
<option value="SJ">Svalbard and Jan Mayen</option>
<option value="SZ">Swaziland</option>
<option value="SE">Sweden</option>
<option value="CH">Switzerland</option>
<option value="SY">Syrian Arab Republic</option>
<option value="TW">Taiwan</option>
<option value="TJ">Tajikistan</option>
<option value="TZ">Tanzania</option>
<option value="TH">Thailand</option>
<option value="TL">Timor-Leste</option>
<option value="TG">Togo</option>
<option value="TK">Tokelau</option>
<option value="TO">Tonga</option>
<option value="TT">Trinidad and Tobago</option>
<option value="TR">Turkey</option>
<option value="TM">Turkmenistan</option>
<option value="TC">Turks and Caicos Islands</option>
<option value="TV">Tuvalu</option>
<option value="UG">Uganda</option>
<option value="UA">Ukraine</option>
<option value="AE">United Arab Emirates</option>
<option value="GB">United Kingdom</option>
<option value="US">United States</option>
<option value="UM">United States Minor Outlying Islands</option>
<option value="UY">Uruguay</option>
<option value="UZ">Uzbekistan</option>
<option value="VU">Vanuatu</option>
<option value="VE">Venezuela</option>
<option value="VN">Viet Nam</option>
<option value="VG">Virgin Islands, British</option>
<option value="VI">Virgin Islands, U.S.</option>
<option value="WF">Wallis and Futuna</option>
<option value="EH">Western Sahara</option>
<option value="YE">Yemen</option>
<option value="ZM">Zambia</option>
<option value="ZW">Zimbabwe</option>';

function btc_postage_get_ajax_form() {
	$order_info = new WC_Order(intval($_GET["order"]));
	$shipping_country = get_post_meta(intval($_GET["order"]), "_shipping_country", true);
	if($shipping_country == "") $shipping_country = $order_info->shipping_country;

    return '<script>
	jQuery(document).ready(function() {
	    var to_country = "'.$shipping_country.'";
	    jQuery("#btc-postage-print-label-form #to_country").val(to_country).change();
	    
	    
	    var from_country = "'.get_option("btc_postage_sender_country").'";
	    jQuery("#btc-postage-print-label-form #from_country").val(from_country).change();
	    
	    jQuery("#btc-postage-print-label-form").submit(function() {
	        var data = {
			    action: "btc_postage_get_rates",
			    formdata: jQuery(this).serialize()
		    };
	        jQuery("#btc-postage-print-label-form .submit-line").hide();
	        jQuery("#btc-postage-print-label-form .loading-line").show();
	        jQuery("#btc-postage-print-label-form .rates-block").html("");
	        jQuery("#btc-postage-print-label-form #service").remove();
	        //var ajaxurl = "https://bitcoinpostage.info/api/get-rates";
	        jQuery.post( ajaxurl, data, function(response) {
			//console.dir(response);
			//console.dir(JSON.stringify(response));
			
			
			    jQuery("#btc-postage-print-label-form .rates-block").append(\'<div class="rates-hr"><hr></div><div class="title-col">Rates</div>\');

				var array_result = JSON.parse(response); 
				if (array_result.error || array_result.message) {
                    if(array_result.message) {
                       jQuery("#btc-postage-print-label-form .rates-block").append(\'<div class="no-result">Error: \'+array_result.message+\'</div>\'); 
                    } else {
                        jQuery("#btc-postage-print-label-form .rates-block").append(\'<div class="no-result">Error: \'+array_result.error+\'</div>\');
                    }
                    jQuery("#btc-postage-print-label-form .submit-line").show();					
				} else { 
			    for(var i=0; i<array_result.length; i++) {
			        jQuery("#btc-postage-print-label-form .rates-block").append(\'<div class="item-rates" data-service-id="\'+i+\'" data-service="\'+array_result[i].service+\'"><div class="left-block"><div class="rates-carrier">\'+array_result[i].carrier+\'</div><div class="rates-name">\'+array_result[i].service_display+\'</div><div class="rates-days">\'+array_result[i].est_delivery_days+\' Business Days</div></div><div class="right-block"><input type="button" class="button button-primary button-large create-label-button" value="Create Label" onclick=\"createLabel(\'+i+\');\"></div><div class="rates-price">\'+array_result[i].rate+\' \'+array_result[i].currency+\'</div></div>\');
			    }
			    if(array_result.length<1) {
			        jQuery("#btc-postage-print-label-form .rates-block").append(\'<div class="no-result">No Available</div>\');
			    } else {
			       jQuery("#btc-postage-print-label-form").append(\'<input type="hidden" name="service" id="service" value="">\');
			       jQuery("#btc-postage-print-label-form .rates-block").show();
			    }
				}
			    jQuery("#btc-postage-print-label-form .loading-line").hide();
		    });
	        
	        return false;
	    });		
	    jQuery("#btc-postage-print-label-form select, #btc-postage-print-label-form input").change(function() {
	        jQuery("#btc-postage-print-label-form .submit-line").show();
	        jQuery("#btc-postage-print-label-form .create-label-button").remove();
	    });    
	});
    function createLabel(service) {
            var service = jQuery(".item-rates[data-service-id="+service+"]").data("service");
            jQuery("#btc-postage-print-label-form #service").val(service);
	        var data = {
			    action: "btc_postage_create_label",
			    formdata: jQuery("#btc-postage-print-label-form").serialize()
		    };
	        jQuery("#btc-postage-print-label-form .submit-line").hide();
	        jQuery("#btc-postage-print-label-form .loading-line").show();
	        jQuery("#btc-postage-print-label-form .rates-block").hide();
	        
	        
	        jQuery.post( ajaxurl, data, function(response) {
	            document.location.href += "&view=1";
				console.dir(response);
		    });
        
        return false;
    }
	</script>';
}

add_action( 'wp_ajax_btc_postage_get_rates', 'btc_postage_get_rates_callback' );
function btc_postage_get_rates_callback() {

    $data_array = array(
        'key' => get_option("btc_postage_api_key"),
        'secret' => get_option("btc_postage_secret_key")
    );

    parse_str($_POST["formdata"], $form_array);

    $form_array["redirect"] = "";

    if(!isset($form_array["service"])) {
        $form_array["service"] = "";
    }

    if(isset($form_array["input_width"])) {
        $form_array["width"] = $form_array["input_width"];
    } else {
        $form_array["width"] = '';
    }
    if(isset($form_array["input_height"])) {
        $form_array["height"] = $form_array["input_height"];
    } else {
        $form_array["height"] = '';
    }
    if(isset($form_array["input_length"])) {
        $form_array["depth"] = $form_array["input_length"];
    } else {
        $form_array["depth"] = '';
    }
    if(isset($form_array["input_weight_lbs"])) {
        $form_array["weight_lbs"] = $form_array["input_weight_lbs"];
    }
    if(isset($form_array["input_weight_oz"])) {
        $form_array["weight_oz"] = $form_array["input_weight_oz"];
    }

    $form_array["package_type"] = "";

    if(isset($form_array["carrier"])) {
        if($form_array["carrier"]=="usps") {
            $form_array["package_type"] = $form_array["packagetype_usps"];
        }
        if($form_array["carrier"]=="fedex") {
            $form_array["package_type"] = $form_array["packagetype_fedex"];
        }
        if($form_array["carrier"]=="fastway") {
            $form_array["package_type"] = $form_array["packagetype_fastway"];
        }
        if($form_array["carrier"]=="couriersplease") {
            $form_array["package_type"] = $form_array["packagetype_couriersplease"];
        }
        if($form_array["carrier"]=="canadapost") {
            $form_array["package_type"] = $form_array["packagetype_canadapost"];
        }
    }

    if($form_array["package_type"]=="USPScustom") {
        $form_array["package_type"] = "custom";
    }
    if($form_array["package_type"]=="FedExcustom") {
        $form_array["package_type"] = "custom";
    }
    if($form_array["package_type"]=="canadapost_custom") {
        $form_array["package_type"] = "custom";
    }

    $post_array = array_merge($data_array, $form_array);

    //$postdata = http_build_query($post_array);

    $opts = array(
           // 'body' => $postdata
            'body' => $post_array,
	    'timeout' => 30
        );


    if(isset($form_array["btc_postage_save_sender"])) {
        update_option( 'btc_postage_sender_name', $form_array["from_name"] );
        update_option( 'btc_postage_sender_address', $form_array["from_street"] );
        update_option( 'btc_postage_sender_apt', $form_array["from_apt"] );
        update_option( 'btc_postage_sender_city', $form_array["from_city"] );
        update_option( 'btc_postage_sender_state', $form_array["from_state"] );
        update_option( 'btc_postage_sender_zipcode', $form_array["from_zip"] );
        update_option( 'btc_postage_sender_country', $form_array["from_country"] );
        update_option( 'btc_postage_sender_phone', $form_array["from_phone"] );
    }

    $response = wp_remote_post('https://bitcoinpostage.info/api/get-rates', $opts);

    if ( is_wp_error( $response ) ) {
        if(isset($response['body'])) {
            print_r( $response['body'] );
        } else {
            $error_message = $response->get_error_message();
            echo "Something went wrong: $error_message";
        }
	} else {
		print_r( $response['body'] );
	}

    wp_die();
}

add_action( 'wp_ajax_btc_postage_create_label', 'btc_postage_create_label_callback' );
function btc_postage_create_label_callback() {
    global $wpdb;
    $data_array = array(
        'key' => get_option("btc_postage_api_key"),
        'secret' => get_option("btc_postage_secret_key")
    );

    parse_str($_POST["formdata"], $form_array);

    $form_array["redirect"] = "";

    if(!isset($form_array["service"])) {
        $form_array["service"] = "";
    }

    if(isset($form_array["input_width"])) {
        $form_array["width"] = $form_array["input_width"];
    } else {
        $form_array["width"] = '';
    }
    if(isset($form_array["input_height"])) {
        $form_array["height"] = $form_array["input_height"];
    } else {
        $form_array["height"] = '';
    }
    if(isset($form_array["input_length"])) {
        $form_array["depth"] = $form_array["input_length"];
    } else {
        $form_array["depth"] = '';
    }
    if(isset($form_array["input_weight_lbs"])) {
        $form_array["weight_lbs"] = $form_array["input_weight_lbs"];
    }
    if(isset($form_array["input_weight_oz"])) {
        $form_array["weight_oz"] = $form_array["input_weight_oz"];
    }

    $form_array["package_type"] = "";

    if(isset($form_array["carrier"])) {
        if($form_array["carrier"]=="usps") {
            $form_array["package_type"] = $form_array["packagetype_usps"];
        }
        if($form_array["carrier"]=="fedex") {
            $form_array["package_type"] = $form_array["packagetype_fedex"];
        }
        if($form_array["carrier"]=="fastway") {
            $form_array["package_type"] = $form_array["packagetype_fastway"];
        }
        if($form_array["carrier"]=="couriersplease") {
            $form_array["package_type"] = $form_array["packagetype_couriersplease"];
        }
         if($form_array["carrier"]=="canadapost") {
            $form_array["package_type"] = $form_array["packagetype_canadapost"];
        }
    }

    if($form_array["package_type"]=="USPScustom") {
        $form_array["package_type"] = "custom";
    }
    if($form_array["package_type"]=="FedExcustom") {
        $form_array["package_type"] = "custom";
    }
    if($form_array["package_type"]=="canadapost_custom") {
        $form_array["package_type"] = "custom";
    }

    $post_array = array_merge($data_array, $form_array);

    $postdata = http_build_query($post_array);

    $opts = array(
		'method'      => 'POST',
    		'timeout'     => 30,
		'body' => $postdata
    );

	$response = wp_remote_post('https://bitcoinpostage.info/api/create-purchase', $opts);
	$result = json_decode ($response['body']);
    $filename = $result->items[0]->filename;

    $wpdb->insert($wpdb->prefix.'btc_post_labels',array('order_id'=>intval($form_array["order_id"]),'label'=>
    trim($filename)),array('%d','%s'));

	if ( is_wp_error( $response ) ) {
		$error_message = $response->get_error_message();
		echo "Something went wrong: $error_message";
	} else {
		echo $filename;
	}

    wp_die();
}

function bitcoin_postage_balance_tr() {
    if(get_option("btc_postage_api_key")!="" && get_option("btc_postage_secret_key")!="") {

		$parameters = array(
			'method'      => 'POST',
			'body'        => array(
				'key' => get_option("btc_postage_api_key"),
				'secret' => get_option("btc_postage_secret_key")
			)
		);

        $response = wp_remote_post('https://bitcoinpostage.info/api/get-credits', $parameters);
		$result = json_decode ($response['body']);

		if (isset($result->error))
		{
			$account_status = $result->error;
			$account_status_color = "#f00";
		} else {
			$account_status = "Key and Secret Verified";
			$account_status_color = "#0a0";
		}

        $return_output = '<tr valign="top">
			<th scope="row" class="titledesc">
				<label for="btc_postage_balance">Account Status</label>
			</th>
		    <td class="forminp forminp-text" style="color:'.$account_status_color.'">
		        '.$account_status.'
			</td>
		</tr>';

		if (!isset($result->error))
		{
			$return_output .= '<tr valign="top">
				<th scope="row" class="titledesc">
					<label for="btc_postage_balance">Your Balance</label>
				</th>
				<td class="forminp forminp-text">
					$'.round($result->credits,2).'
				</td>
			</tr>';
		}
		return $return_output;

    } else {
        return '';
    }

}

function activate_bitcoinpostageplugin()
{
  global $wpdb;
  $db_table_name = $wpdb->prefix . 'btc_post_labels';  // table name
  $charset_collate = $wpdb->get_charset_collate();

 //Check to see if the table exists already, if not, then create it
if($wpdb->get_var( "show tables like '$db_table_name'" ) != $db_table_name )
 {

       $sql = "CREATE TABLE $db_table_name (
                id int(11) NOT NULL auto_increment,
                order_id bigint(20) DEFAULT NULL,
                label varchar(200) DEFAULT NULL,
                UNIQUE KEY id (id)
        ) $charset_collate;";

   require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
   dbDelta( $sql );

   $test_db_version = '1.0';
   add_option( 'test_db_version', $test_db_version );
 }
}

 register_activation_hook( __FILE__, "activate_bitcoinpostageplugin" );


?>
